<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Healthinsurance;
use App\Models\InsuranceEnquiriesBaseTable;
use App\Models\BimaplanEnquiryForm;
use Auth;
use Session;
use Illuminate\Support\Facades\Hash;
use GuzzleHttp\Client;
use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Http;

class InsurenceController extends Controller
{
    public function showCompanies($id)
    {
        $layout = 'layouts.app'; // Define the layout variable
        $companies = DB::table('insurance_companies')->where('subcategory_id', $id)->get();
        return view('companies', compact('companies', 'layout'));
    }
    public function showSubCategory($id)
    {
        $subcategory = DB::table('insurance_subcategories')->where('category_id', $id)->get();
        $category = DB::table('insurance_categories')->where('id', $id)->pluck('category_name')->first();

        return view('subcategory', ['subcategory' => $subcategory, 'layout' => 'layouts.app', 'category_name' => $category]);
    }

    public function showVehicles($id)
    {
        $layout = 'layouts.app'; // Define the layout variable
        $vehicles = DB::table('vehicle_groups')->where('service_id', $id)->get();
        return view('vehicles', compact('vehicles', 'layout'));
    }

    public function showPolicies($id, $subcategory)
    {
        $layout = 'layouts.app'; // Define the layout variable
        $policies = DB::table('insurence_policies')
            ->where('company_id', $id)
            ->where('subcategory_id', $subcategory)
            ->get();
        return view('policies', compact('policies', 'layout'));
    }
    public function bimaplanenquiry($id, $sid)
    {
        $country = DB::connection('mysql2')->table('richindi_dbs.countries')->where('status', 'Active')->get();
        return view('bimaplanenquiryform', ["country" => $country, "policy" => $id, "seller" => $sid, 'layout' => 'layouts.app']);
    }
    public function showDetails($id)
    {
        $layout = 'layouts.app'; // Define the layout variable
        $detail = DB::table('insurence_policies')->where('id', $id)->first();
        return view('details', compact('detail', 'layout'));
    }
    public function healthinsuranceform($id, $sid)
    {
        $country = DB::connection('mysql2')->table('richindi_dbs.countries')->where('status', 'Active')->get();
        return view('healthinsurance', ["country" => $country, "policy" => $id, "seller" => $sid]);
    }
    public function bimaplanenquiryform(Request $request)
    {


        $image = '';
        //    ******** Image uploade start ********
        if ($request->hasFile('aadhar_front_side')) {
            $rand = rand(100, 999);
            $image = time() . '.' . $request->aadhar_front_side->extension();
            $imageOriginalName = $request->aadhar_front_side->getClientOriginalName();
            $request->aadhar_front_side->move(public_path('uploads/aadhar_card_front'), $image);
        }
        // ******** Image uploade end ********

        $image2 = '';
        // ******** Image uploade start ********
        if ($request->hasFile('aadhar_back_side')) {
            $rand = rand(100, 999);
            $image2 = time() . '.' . $request->aadhar_back_side->extension();
            $imageOriginalName = $request->aadhar_back_side->getClientOriginalName();
            $request->aadhar_back_side->move(public_path('uploads/aadhar_card_back'), $image2);
        }
        // ******** Image uploade end ********

        $image3 = '';
        //  ******** Image uploade start ********
        if ($request->hasFile('receipt')) {
            $rand = rand(100, 999);
            $image3 = time() . '.' . $request->receipt->extension();
            $imageOriginalName = $request->receipt->getClientOriginalName();
            $request->receipt->move(public_path('uploads/receipt'), $image3);
        }
        // ******** Image uploade end ********
        $baseregister = new InsuranceEnquiriesBaseTable();
        $baseregister->user_id = $request->post('userid');
        $baseregister->policy_id = $request->post('policy_id');
        $baseregister->seller_id = $request->post('seller_id');
        $baseregister->user_phone = $request->post('mobile');
        $baseregister->save();

        $register = new BimaplanEnquiryForm();
        $register->base_enquiry_id = $baseregister->id;
        $register->first_name = $request->post('first_name');
        $register->middle_name = $request->post('middle_name');
        $register->last_name = $request->post('last_name');
        $register->gender = $request->post('gender');
        $register->dob = $request->post('dob');
        $register->email = $request->post('email');
        $register->mobile = $request->post('mobile');
        $register->house_name = $request->post('house_name');
        $register->post_office = $request->post('postoffice');
        $register->pincode = $request->post('pincode');
        $register->district = $request->post('district');
        $register->village = $request->post('village');
        $register->state = $request->post('state');
        $register->id_proof = $request->post('id_proof');
        $register->id_proof_number = $request->post('id_proof_number');
        $register->ocupation = $request->post('occupation');
        $register->nominee_first_name = $request->post('nominee_first_name');
        $register->nominee_middle_name = $request->post('nominee_middle_name');
        $register->nominee_last_name = $request->post('nominee_last_name');
        $register->nominee_date_of_birth = $request->post('nominee_dob');
        $register->nominee_gender = $request->post('nominee_gender');
        $register->nominee_mobile = $request->post('nominee_mobile');
        $register->nominee_house_name = $request->post('nominee_house_name');
        $register->nominee_post_office = $request->post('nominee_postoffice');
        $register->nominee_pincode = $request->post('nominee_pincode');
        $register->nominee_district = $request->post('nominee_district');
        $register->nominee_state = $request->post('nominee_state');
        $register->nominee_aadhar = $request->post('nominee_aadhar');
        $register->relation_with_applicant = $request->post('relation_with_applicant');
        $register->dbs_user_id = $request->post('userid');
        $register->aadhar_front_image = $image;
        $register->aadhar_back_image = $image2;
        $register->receipt = $image3;
        $register->save();


        if ($register->id) {
            $successmessage = "Thank you for registering, We will contact you soon.";
            return  view('success', ["successmessage" => $successmessage]);


            $phone_encoded = base64_encode(utf8_encode($request->post('mobile')));
            $partnerCode_encoded = base64_encode(utf8_encode('FGCMBO'));
            $created_by = $partnerCode_encoded . $phone_encoded;

            $req_data = [
                'additionalFields' => [
                    'dummyField1' => 'dummyValue1'
                ],
                'firstName' => $request->post('first_name'),
                'lastName' => $request->post('last_name'),
                'mobile' => $request->post('mobile'),
                'option' => 'Option 1',
                'productCode' => 'FGCMBO',
                'sponser' => 'payU',
                'createdBy' => $created_by
            ];


            $output = false;

            $encrypt_method = "AES-256-CBC";
            $secret_key = 'b11b4f86cf186d127caa05db929d6f41';
            $secret_iv = '2234567899991234';


            $output = openssl_encrypt(json_encode($req_data), $encrypt_method, $secret_key, 0, $secret_iv);
            $k =   "BM" . '|' . "BIMAPLAN" . '|' . $req_data['firstName'] . '|' . $req_data['mobile'] . '|' . $req_data['productCode'] . '|' . '|' . '|' . '|' . '|';
            $checkSum = hash('sha512', $k);

            $headers = [
                'Authorization' => 'Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
                'Content-Type'  => 'application/json',
            ];



            $curl = curl_init();
            $date = now();
            curl_setopt_array($curl, array(
                CURLOPT_URL => 'https://uat.ewirecards.com/bimaplan-be/bimaPlan',
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => '',
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 0,
                CURLOPT_FOLLOWLOCATION => true,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => 'POST',
                CURLOPT_POSTFIELDS => '{
                    "ewire_reqid": "38707",
                    "ewire_custid": "99015",
                    "requestapi": "leadConsent",
                    "timeStamp":"' . $date . '",
                    "req_data": "' . $output . '",
                    "checksum": "' . $checkSum . '"
}',
                CURLOPT_HTTPHEADER => array(
                    'Authorization: Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
                    'Content-Type: application/json'
                ),
            ));

            $response = curl_exec($curl);

            curl_close($curl);

            $r = json_decode($response);

            //if($r->resp_type){
            //  $output =openssl_decrypt($r->resp_frm_ewire, $encrypt_method, $secret_key, 0, $secret_iv);
            $string = $r->resp_frm_ewire;
            $output = openssl_decrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);
            $json_data = str_replace('\'', '"', $output);
            $url = json_decode($json_data);

            return view('approval_page', ['url' => $url->details->entity->consentUrl, 'phone' => $req_data['mobile'], 'email' => $request->post('email'), 'id' => 140]);
        }
    }

    public function healthinsurancesaveform(Request $request)
    {
        // $validate=$request->validate([
        //     'proposer_name'=>'required',
        //     'proposer_mobile'=>'required|digits:10',
        //     'type'=>'required',
        //     'zone'=>'required',
        //     'planoption'=>'required',
        //     'suminsured'=>'required',
        //     'familydefinition'=>'required',
        //   // 'primaryage'=>'required',
        //     //'premium'=>'required',
        //     'policyterm'=>'required',
        //     'totalpremium'=>'required',
        //     'payoption'=>'required',
        //     'numofinstalment'=>'required',
        //     'gstreg'=>'required',
        //     'gstapplicableamount'=>'required',
        //     'finalpremium'=>'required',
        //     'proposer_whatsapp'=>'required|digits:10',
        //     'proposer_dob'=>'required',
        //     'age'=>'required',
        //     'education'=>'required',
        //     'spousename'=>'required',
        //     'rwspouse'=>'required',
        //     'occupation'=>'required',
        //     'annual_income'=>'required',
        //     'marital_status'=>'required',
        //     'gender'=>'required',
        //     'nominee'=>'required',
        //     'nomineerw'=>'required',
        //     'country'=>'required',
        //     'state'=>'required',
        //     'district'=>'required',
        //     'village'=>'required',
        //     'ashaworker'=>'required'
        //     ]);
        if ($request->post('familydefinition') == 'Two Adults' || $request->post('familydefinition') == 'Two Adults + One Child' || $request->post('familydefinition') == 'Two Adults + Two Children' || $request->post('familydefinition') == 'Two Adults + Three Children') {
            $validate = $request->validate(['spouseage' => 'required']);
        }
        if ($request->post('familydefinition') == 'One Adult + One Child' || $request->post('familydefinition') == 'One Adult + Two Children' || $request->post('familydefinition') == 'One Adult + Three Children' || $request->post('familydefinition') == 'Two Adults + One Child' || $request->post('familydefinition') == 'Two Adults + Two Children' || $request->post('familydefinition') == 'Two Adults + Three Children') {
            $validate = $request->validate(['dependend_child1' => 'required']);
        }
        if ($request->post('familydefinition') == 'One Adult + Two Children' || $request->post('familydefinition') == 'One Adult + Three Children' ||  $request->post('familydefinition') == 'Two Adults + Two Children' || $request->post('familydefinition') == 'Two Adults + Three Children') {
            $validate = $request->validate(['dependend_child2' => 'required']);
        }
        if ($request->post('familydefinition') == 'One Adult + Three Children' || $request->post('familydefinition') == 'Two Adults + Three Children') {
            $validate = $request->validate(['dependend_child3' => 'required']);
        }
        if (($request->post('policyterm') == 2 && $request->post('payoption') == 'Single Premium Payment') || ($request->post('policyterm') == 3 && $request->post('payoption') == 'Single Premium Payment')) {
            $validate = $request->validate(['discount' => 'required']);
        }
        if ($request->post('proposer_id')) {
            $baseregister = new InsuranceEnquiriesBaseTable();
            $baseregister->user_id = $request->post('userid');
            $baseregister->policy_id = $request->post('policy_id');
            $baseregister->seller_id = $request->post('seller_id');
            $baseregister->user_phone = $request->post('mobile');
            $baseregister->save();


            $update = Healthinsurance::where(['id' => $request->post('proposer_id')])
                ->update(array(
                    'base_enquiry_id' => $baseregister->id,
                    'proposer_name' => $request->post('proposer_name'),
                    'proposer_mobile' => $request->post('proposer_mobile'),
                    'type' => $request->post('type'),
                    'zone' => $request->post('zone'),
                    'planoption' => $request->post('planoption'),
                    'suminsured' => $request->post('suminsured'),
                    'familydefinition' => $request->post('familydefinition'),
                    'primaryage' => $request->post('primaryage'),
                    'spouseage' => $request->post('spouseage'),
                    'dependend_child1' => $request->post('dependend_child1'),
                    'dependend_child2' => $request->post('dependend_child2'),
                    'dependend_child3' => $request->post('dependend_child3'),
                    'premium' => $request->post('premium'),
                    'policyterm' => $request->post('policyterm'),
                    'totalpremium' => $request->post('totalpremium'),
                    'payoption' => $request->post('payoption'),
                    'numofinstalment' => $request->post('numofinstalment'),
                    'discount' => $request->post('discount'),
                    'gstreg' => $request->post('gstreg'),
                    'gstapplicableamount' => $request->post('gstapplicableamount'),
                    'finalpremium' => $request->post('finalpremium'),
                    'proposer_whatsapp' => $request->post('proposer_whatsapp'),
                    'proposer_dob' => $request->post('proposer_dob'),
                    'age' => $request->post('age'),
                    'education' => $request->post('education'),
                    'spousename' => $request->post('spousename'),
                    'rwspouse' => $request->post('rwspouse'),
                    'occupation' => $request->post('occupation'),
                    'annual_income' => $request->post('annual_income'),
                    'marital_status' => $request->post('marital_status'),
                    'gender' => $request->post('gender'),
                    'nominee' => $request->post('nominee'),
                    'nomineerw' => $request->post('nomineerw'),
                    'country_id' => $request->post('country'),
                    'state_id' => $request->post('state'),
                    'district_id' => $request->post('district'),
                    'village_id' => $request->post('village'),
                    'ashaworker_id' => $request->post('ashaworker'),
                    'infoman_id' => $request->post('infoman'),
                    'remarks' => $request->post('remarks'),
                    'user_id' => $request->post('id')
                ));



            if ($update) {
                $successmessage = "Thank you for registering, We will contact you soon.";
                return  view('success', ["successmessage" => $successmessage]);
            }
        } else {

            $register = new Healthinsurance();
            $register->proposer_name = $request->post('proposer_name');
            $register->proposer_mobile = $request->post('proposer_mobile');
            $register->type = $request->post('type');
            $register->zone = $request->post('zone');
            $register->planoption = $request->post('planoption');
            $register->suminsured = $request->post('suminsured');
            $register->familydefinition = $request->post('familydefinition');
            $register->primaryage = $request->post('primaryage');
            $register->premium = $request->post('premium');
            $register->policyterm = $request->post('policyterm');
            $register->totalpremium = $request->post('totalpremium');
            $register->payoption = $request->post('payoption');
            $register->numofinstalment = $request->post('numofinstalment');
            $register->gstreg = $request->post('gstreg');
            $register->gstapplicableamount = $request->post('gstapplicableamount');
            $register->finalpremium = $request->post('finalpremium');
            $register->proposer_whatsapp = $request->post('proposer_whatsapp');
            $register->proposer_dob = $request->post('proposer_dob');
            $register->age = $request->post('age');
            $register->education = $request->post('education');
            $register->spousename = $request->post('spousename');
            $register->rwspouse = $request->post('rwspouse');
            $register->occupation = $request->post('occupation');
            $register->annual_income = $request->post('annual_income');
            $register->marital_status = $request->post('marital_status');
            $register->gender = $request->post('gender');
            $register->nominee = $request->post('nominee');
            $register->nomineerw = $request->post('nomineerw');
            $register->country_id = $request->post('country');
            $register->state_id = $request->post('state');
            $register->district_id = $request->post('district');
            $register->village_id = $request->post('village');
            $register->ashaworker_id = $request->post('ashaworker');
            $register->infoman_id = $request->post('infoman');
            $register->remarks = $request->post('remarks');
            $register->user_id = $request->post('id');
            $register->save();
            if ($register->id) {
                $successmessage = "Thank you for registering, We will contact you soon.";
                return  view('success', ["successmessage" => $successmessage]);
            }
        }
    }

    public function fetchstates()
    {
        $country_id = $_GET['countryid'];
        $state = DB::connection('mysql2')->table('richindi_dbs.states')->where('status', 'Active')->where('country_id', $country_id)->get();
        $result = array();
        foreach ($state as $row) {
            array_push(
                $result,
                array('stateid' => $row->state_id, 'statename' => $row->state_name)
            );
        }
        echo json_encode(array('result' => $result));
    }
    public function fetchdistricts()
    {
        $state_id = $_GET['stateid'];
        $district = DB::connection('mysql2')->table('richindi_dbs.districts')->where('status', 'Active')->where('state_id', $state_id)->get();
        $result = array();
        foreach ($district as $row) {
            array_push(
                $result,
                array('districtid' => $row->district_id, 'districtname' => $row->district_name)
            );
        }
        echo json_encode(array('result' => $result));
    }

    public function fetchvillages()
    {
        $district_id = $_GET['districtid'];
        $village = DB::connection('mysql2')->table('richindi_dbs.villages')->where('status', 'Active')->where('district_id', $district_id)->orderBy('village_name', 'ASC')->get();
        $result = array();
        foreach ($village as $row) {
            array_push(
                $result,
                array('villageid' => $row->village_id, 'villagename' => $row->village_name)
            );
        }
        echo json_encode(array('result' => $result));
    }

    public function fetchashaworkers()
    {
        $village_id = $_GET['villageid'];
        $ashaworker = DB::connection('mysql2')->table('richindi_dbs.ashaworkers')->where('status', 'Active')->where('village_id', $village_id)->get();
        $result = array();
        foreach ($ashaworker as $row) {
            array_push(
                $result,
                array('ashaworkerid' => $row->ashaworker_id, 'ashaworkername' => $row->fullname)
            );
        }
        echo json_encode(array('result' => $result));
    }
    public function fetchinfomen()
    {
        $ashaworker_id = $_GET['ashaworkerid'];
        $infoman = DB::connection('mysql2')->table('richindi_dbs.infomans')->where('status', 'Active')->where('ashaworker_id', $ashaworker_id)->get();
        //$infoman=Infoman::where('status','Active')->where('ashaworker_id',$ashaworker_id)->get();
        $result = array();
        foreach ($infoman as $row) {
            array_push(
                $result,
                array('infomanid' => $row->infoman_id, 'infomanname' => $row->fullname)
            );
        }
        echo json_encode(array('result' => $result));
    }
    public function save_healthinsurance_mobile()
    {
        if ($_GET['id']) {
            $update = DB::connection('mysql2')->table('richindi_dbs.healthinsurances')->where(['id' => $_GET['id']])->update(array('proposer_mobile' => $_GET['mobile']));
            echo $userid = $_GET['id'];
        } else {
            $register = new Healthinsurance();
            $mobile = $_GET['mobile'];
            $register->proposer_mobile = $_GET['mobile'];
            $register->save();
            echo $register->id;
        }
    }

    public function logout(Request $request)
    {

        auth()->guard('web')->logout();
        Auth::logout();
        Session::flush();
        Session::put('success', 'You are logout sucessfully');
        Session::put('prev_url', 'https://insurance.richindians.in/');
        return redirect(url('https://www.richindians.in/richlogout'));
    }
    public function logoutMain(Request $request)
    {

        auth()->guard('web')->logout();
        Auth::logout();
        Session::flush();
        Session::put('success', 'You are logout sucessfully');
        return redirect(url('https://insurance.richindians.in/'));
    }
    public function payment()
    {
        $phone_encoded = base64_encode(utf8_encode('9188360241'));
        $partnerCode_encoded = base64_encode(utf8_encode('FGCMBO'));
        $created_by = $partnerCode_encoded . $phone_encoded;

        $req_data = [
            'additionalFields' => [
                'dummyField1' => 'dummyValue1'
            ],
            'firstName' => 'Ragesh',
            'lastName' => 'K R',
            'mobile' => '9188360241',
            'option' => 'Option 1',
            'productCode' => 'FGCMBO',
            'sponser' => 'payU',
            'createdBy' => $created_by
        ];


        $output = false;

        $encrypt_method = "AES-256-CBC";
        $secret_key = 'b11b4f86cf186d127caa05db929d6f41';
        $secret_iv = '2234567899991234';


        $output = openssl_encrypt(json_encode($req_data), $encrypt_method, $secret_key, 0, $secret_iv);
        $k =   "BM" . '|' . "BIMAPLAN" . '|' . $req_data['firstName'] . '|' . $req_data['mobile'] . '|' . $req_data['productCode'] . '|' . '|' . '|' . '|' . '|';
        $checkSum = hash('sha512', $k);

        $headers = [
            'Authorization' => 'Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
            'Content-Type'  => 'application/json',
        ];



        $curl = curl_init();
        $id = 52;
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://uat.ewirecards.com/bimaplan-be/bimaPlan',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
                "ewire_reqid": "3870' . $id . '",
                "ewire_custid": "99015",
                "requestapi": "leadConsent",
                "timeStamp": "2024-02-01 15: 27: 09.853",
                "req_data": "' . $output . '",
                "checksum": "' . $checkSum . '"
}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $r = json_decode($response);
        //print_r($r);
        //if($r->resp_type){
        //  $output =openssl_decrypt($r->resp_frm_ewire, $encrypt_method, $secret_key, 0, $secret_iv);
        $string = $r->resp_frm_ewire;
        $output = openssl_decrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);
        $json_data = str_replace('\'', '"', $output);
        $url = json_decode($json_data);
        return view('approval_page', ['url' => $url->details->entity->consentUrl, 'phone' => $req_data['mobile'], 'email' => 'phpapplicationuser@gmail.com', 'id' => 52]);

        //return view('approval_page',['url'=>$url->details->entity->consentUrl,'phone'=>$req_data['mobile'],'email'=>'phpapplicationuser@gmail.com']);   


    }
    public function intiatePayment(Request $request)
    {


        //********************* crated by method start ***************
        $phone_encoded = base64_encode(utf8_encode($request->phone));
        $partnerCode_encoded = base64_encode(utf8_encode('FGCMBO'));
        $created_by = $partnerCode_encoded . $phone_encoded;

        // ****************************** crated by method start end ************************
        $req_data = [
            'mobile' => $request->phone,
            'env' => 'test',
            'createdBy' => $created_by,
            'email' => $request->email

        ];

        $output = false;

        $encrypt_method = "AES-256-CBC";
        $secret_key = 'b11b4f86cf186d127caa05db929d6f41';
        $secret_iv = '2234567899991234';


        $output = openssl_encrypt(json_encode($req_data), $encrypt_method, $secret_key, 0, $secret_iv);
        $k =   "BM" . '|' . "BIMAPLAN" . '|' . $req_data['mobile'] . '|' . '|' . '|' . '|' . '|' . '|' . '|';
        $checkSum = hash('sha512', $k);
        /* print_r($output);
echo "<br><br><br>";
print_r($checkSum);die(); */
        $headers = [
            'Authorization' => 'Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
            'Content-Type'  => 'application/json',
        ];



        $curl = curl_init();
        $date = now();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://uat.ewirecards.com/bimaplan-be/bimaPlan',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
                "ewire_reqid": "38706",
                "ewire_custid": "99015",
                "requestapi": "checkConsent",
                "timeStamp": "' . $date . '",
                "req_data": "' . $output . '",
                "checksum": "' . $checkSum . '"
}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        $response;
        return $response;
    }

    public function confirmPayment(Request $request)
    {


        //********************* crated by method start ***************
        $phone_encoded = base64_encode(utf8_encode('9188360241'));
        $partnerCode_encoded = base64_encode(utf8_encode('FGCMBO'));
        $created_by = $partnerCode_encoded . $phone_encoded;

        // ****************************** crated by method start end ************************
        $req_data = [
            "additionalFields" => [
                "dummyField1" => "dummyvalue1"
            ],
            "applicantDetails" => [
                "addressLine1" => "Koramangala Bangalore",
                "addressLine2" => "NA",
                "city" => "Belgaum",
                "dateOfBirth" => "1998-10-22",
                "documentNumber" => "HHHHH12xxx",
                "email" => "phpapplicationuser@gmail.com",
                "firstName" => "Rahul ",
                "gender" => "Male",
                "govtDocumentType" => "PAN",
                "isApplicantInGoodHealth" => "Yes",
                "lastName" => ".",
                "mobileNumber" => "9188360241",
                "occupation" => "salaried",
                "pinCode" => "560075",
                "state" => "Karnataka"
            ],
            "createdBy" => $created_by,
            "nomineeDetails" => [
                "dateOfBirth" => "03-02-2000",
                "firstName" => "Rohit",
                "gender" => "MALE",
                "lastName" => "Vijapur",
                "mobileNumber" => "9447230494",
                "nomineeAddressLine1" => "Line 1",
                "nomineeAddressLine2" => "Line 2",
                "nomineeCity" => "Bengaluru",
                "nomineePincode" => "590055",
                "nomineeState" => "Karnataka",
                "percentageShare" => "100",
                "relationship" => "BROTHER"
            ],
            "plan" => "Option 1",
            "productCode" => "FGCMBO",
            "sponser" => " ",
            "paymentStatus" => "payU Response"
        ];

        $output = false;

        $encrypt_method = "AES-256-CBC";
        $secret_key = 'b11b4f86cf186d127caa05db929d6f41';
        $secret_iv = '2234567899991234';


        $output = openssl_encrypt(json_encode($req_data), $encrypt_method, $secret_key, 0, $secret_iv);
        $k =   "BM" . '|' . "BIMAPLAN" . '|' . $req_data['applicantDetails']['mobileNumber'] . '|' . $req_data['nomineeDetails']['mobileNumber'] . '|' . $req_data['productCode'] . '|' . '|' . '|' . '|' . '|';

        $checkSum = hash('sha512', $k);
        /* print_r($output);
echo "<br><br><br>";
print_r($checkSum);die(); */
        $headers = [
            'Authorization' => 'Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
            'Content-Type'  => 'application/json',
        ];



        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://uat.ewirecards.com/bimaplan-be/bimaPlan',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
                "ewire_reqid": "38711",
                "ewire_custid": "99015",
                "requestapi": "submitProposal",
                "timeStamp": "2024-02-01 15: 27: 09.853",
                "req_data": "' . $output . '",
                "checksum": "' . $checkSum . '"
}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        //echo $response;
        $r = json_decode($response);

        $string = $r->resp_frm_ewire;
        $output = openssl_decrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);
        //$string="ASraYhyNUnkwXvRdkpaCoZUYfw2/D/yNoN5NlhWev/sDOH1TnIg+2Wz8trIrxjbiUqq+NOSe6D6PCzsgnAtm9G7qXrR9pCPp9hLLOoiBLpxLQAXkB+8wiCEneXV6Ird7MkyxrFVbZ4q5KHD4Qd2Lt7WlsxPJnc9ySYtDsWVmouf2U/VURreaUVpyTCr9WP7c10VSpWGtiKlSKPI6ooatN58PINr+Qk6cyHWSxSG0C68MIpMb4ykhhNpjImtzRSganFMMLcSCORT1p09KBior1cAIyjro9CKhQjaMGXjNZJUFmuKRedVN4gM1HaGltete";
        //$output = openssl_decrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);
        $json_data = str_replace('\'', '"', $output);
        $url = json_decode($json_data);
        print_r($url);
        die();
    }
    public function paymentStatus(Request $request)
    {

        $r = BimaplanEnquiryForm::where('transactionId', $request->transactionId)->where('mobile', $request->PhoneNumber)->first();
        //print_r($r);
        // return response()->json($data);
        $res = BimaplanEnquiryForm::where('transactionId', $request->transactionId)->where('mobile', $request->PhoneNumber)
            ->update([
                'transactionId' => $request->transactionId,
                'payment_status' => $request->paymentStatus
            ]);

        //  die();       
        //********************* crated by method start ***************
        $phone_encoded = base64_encode(utf8_encode($r->mobile));
        $partnerCode_encoded = base64_encode(utf8_encode('FGCMBO'));
        $created_by = $partnerCode_encoded . $phone_encoded;

        // ****************************** crated by method start end ************************
        $req_data = [
            "additionalFields" => [
                "dummyField1" => "dummyvalue1"
            ],
            "applicantDetails" => [
                "addressLine1" => $r->post_office . ' ,' . $r->village . ' ,' . $r->district . ' ,' . $r->state . ' ,' . $r->pincode,
                "addressLine2" => "NA",
                "city" => $r->village,
                "dateOfBirth" => $r->dob,
                "documentNumber" => "HHHHH12xxx",
                "email" => $r->email,
                "firstName" => $r->first_name,
                "gender" => $r->gender,
                "govtDocumentType" => $r->id_proof,
                "isApplicantInGoodHealth" => "Yes",
                "lastName" => $r->last_name,
                "mobileNumber" => $r->mobile,
                "occupation" => $r->ocupation,
                "pinCode" => $r->pincode,
                "state" => $r->state
            ],
            "createdBy" => $created_by,
            "nomineeDetails" => [
                "dateOfBirth" => $r->nominee_date_of_birth,
                "firstName" => $r->nominee_first_name,
                "gender" => $r->nominee_gender,
                "lastName" => $r->nominee_last_name,
                "mobileNumber" => $r->nominee_mobile,
                "nomineeAddressLine1" => $r->nominee_post_office . ' ,' . $r->nominee_district . ' ,' . $r->nominee_state . ' ,' . $r->nominee_pincode,
                "nomineeAddressLine2" => "NA",
                "nomineeCity" => $r->district,
                "nomineePincode" => $r->pincode,
                "nomineeState" => $r->state,
                "percentageShare" => 100,
                "relationship" => $r->relation_with_applicant
            ],
            "plan" => "Option 1",
            "productCode" => "FGCMBO",
            "sponser" => " ",
            "paymentStatus" => "payU Response"
        ];

        $output = false;

        $encrypt_method = "AES-256-CBC";
        $secret_key = 'b11b4f86cf186d127caa05db929d6f41';
        $secret_iv = '2234567899991234';


        $output = openssl_encrypt(json_encode($req_data), $encrypt_method, $secret_key, 0, $secret_iv);
        $k =   "BM" . '|' . "BIMAPLAN" . '|' . $req_data['applicantDetails']['mobileNumber'] . '|' . $req_data['nomineeDetails']['mobileNumber'] . '|' . $req_data['productCode'] . '|' . '|' . '|' . '|' . '|';

        $checkSum = hash('sha512', $k);

        $headers = [
            'Authorization' => 'Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
            'Content-Type'  => 'application/json',
        ];



        $curl = curl_init();
        $date = now();
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://uat.ewirecards.com/bimaplan-be/bimaPlan',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => '{
                "ewire_reqid": "38711",
                "ewire_custid": "99015",
                "requestapi": "submitProposal",
                "timeStamp":"' . $date . '",
                "req_data": "' . $output . '",
                "checksum": "' . $checkSum . '"
}',
            CURLOPT_HTTPHEADER => array(
                'Authorization: Basic YmltYXBsYW46YmltYXBsYW5AMTIz',
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);

        $r = json_decode($response);

        $string = $r->resp_frm_ewire;
        $output = openssl_decrypt($string, $encrypt_method, $secret_key, 0, $secret_iv);

        $json_data = str_replace('\'', '"', $output);
        $url = json_decode($json_data);
        //print_r($url );

        $res = BimaplanEnquiryForm::where('transactionId', $request->transactionId)->where('mobile', $request->PhoneNumber)
            ->update([
                'applicationNumber' => $url->details->applicationNumber,
                'externalReferenceNumber' => $url->details->externalReferenceNumber
            ]);

        $successmessage = $url->message . ".  Application Number " . $url->details->applicationNumber . "  Thank you for registering, We will contact you soon.";
        return  view('success', ["successmessage" => $successmessage]);
    }

    public function updatePaymentBeforePayment(Request $request)
    {
        $data = BimaplanEnquiryForm::where('id', $request->id)
            ->update([
                'transactionId' => $request->tid,
                'payment_amount' => $request->amount
            ]);
        return response()->json($data);
    }
}
